var title;
var image;
var questions = [];
var answers = [];
var currentQuestionId;
var msgPleaseAnswer = "You must answer the question before continuing.";
var msgCorrect = "Correct. Click or tap anywhere to continue";
var msgIncorrect = "Incorrect. Click or tap anywhere to continue";
var msgTryAgain = "Not all answers are correct. Click or tap here to play again.";
var msgCongratulations = "Congratulations. Well done!";

var isTouch = ('ontouchstart' in window);
var CLICK = isTouch ? 'touchstart' : 'click';
var MOUSEOVER = isTouch ? 'touchstart' : 'mouseover';

var FADE_IN_SPEED = 500;

getXML();

function getXML() {
  $.ajax({
    type : "GET",
    url : captivate_config,
    dataType : "xml",
    success : xmlParser
  });
}

function xmlParser(xml) {
  var $xml = $(xml);

  // Extract title and image from XML.
  title = $xml.find("title").text();
  image = $xml.find("img").text();

  // Extract questions from XML.
  $xml.find("question").each(function() {
    var options = [];
    var pointers = [];
    var prompt;

    // Extract answer options.
    $(this).find("option").each(function() {
      options.push({
        'audio' : $(this).attr("audio"),
        'answer' : $(this).attr("answer"),
        'text' : $(this).text()
      });
    });

    // Extract optional pointers.
    $(this).find("pointer").each(function() {
      pointers.push({
        'img' : $(this).attr("img"),
        'x' : $(this).attr("x"),
        'y' : $(this).attr("y"),
        'rotation' : $(this).attr("rotation")
      });
    });

    // Extract prompt.
    $(this).find("prompt").each(function() {
      prompt = {
        'text' : $(this).text(),
        'audio' : $(this).attr("audio")
      };
    });
        
    if (isTouch && prompt) {
      // Remove mention of mouse on touch devices.
      prompt.text = prompt.text.replace("Click", "Touch");
      prompt.text = prompt.text.replace("click", "touch");
    }

    // Add to list of questions.
    questions.push({
      'id' : Number($(this).attr("id")),
      'text' : $(this).attr("text"),
      'img' : $(this).attr("img"),
      'audio' : $(this).attr("audio"),
      'paddingTop' : $(this).attr("paddingTop"),
      'paddingRight' : $(this).attr("paddingRight"),
      'options' : options,
      'pointers' : pointers,
      'prompt' : prompt
    });
  });

  showIntroduction();

}

function showIntroduction() {
  $('#quiz').children().remove();
  $('#quiz').append('<img id=\"captivateIntroImage\" src=\"' + image + '\" />');
  $('#captivateIntroImage')
    .load(
      function() {
        $('#captivateIntroImage').fadeIn(FADE_IN_SPEED);
        $('#quiz').append('<button id=\"startButton\">Start</button>');
        $('#startButton')
          .bind(
            CLICK,
            function() {
              // Clear introduction
              $('#quiz').children().remove();

              // Add quiz elements
              $('#quiz').append('<div id=\"quizBody\"></div>');
              $('#quizBody').append('<div id=\"prompt\"></div>');
              $('#quizBody').append('<div id=\"quizImage\"></div>');
              $('#quizBody').append('<div id=\"question\"></div>');
              $('#quizBody').append('<ol id=\"answers\"></ol>');
              $('#quizBody').append('<hr style=\"clear:both; display:none;\" />');

              $('#quizBody')
                  .append(
                      '<table id="quizFooter"><tr><td colspan=\"2\" id=\"messages\"></td></tr><tr><td id=\"questionNo\"></td><td id="quizButtonBar"></td></tr></table>');
              $('#quizButtonBar').append('<button id=\"quizSubmit\" onclick=\"submitQuestion();\">Submit</button>');
              $('#quizButtonBar').append('<button id=\"quizSkip\"   onclick=\"skipQuestion();\">Skip</button>');
              $('#quizButtonBar').append('<button id=\"quizBack\"   onclick=\"previousQuestion();\">Back</button>');

              // Reset variables.
              currentQuestionId = 0;
              answers = [];

              // Show first question.
              showQuestion();
            });
      });

}

function showQuestion() {
  // Remove click handler and enable buttons.
  $(document).unbind(CLICK);
  $("#quizSubmit").removeAttr('disabled');
  $("#quizSkip").removeAttr('disabled');
  $("#quizBack").removeAttr('disabled');
  
  if (currentQuestionId == 0) {
    // disable previous button.
    $('#quizBack').css({
      'display' : 'none'
    });
  } else {
    $('#quizBack').css({
      'display' : 'block'
    });
  }

  // Hide image ready for fade in.
  $('#quizImage').css({
    'display' : 'none'
  });

  // Get current question.
  var question = questions[currentQuestionId];

  // Display quiz image.
  $('#quizImage').children().remove();
  $('#quizImage').append('<img src=\"' + question.img + '\" />');

  // Display "Question 1 or 10" status.
  $('#questionNo').children().remove();
  $('#questionNo').append('<p>Question ' + (currentQuestionId + 1) + ' of ' + questions.length + '</p>');

  // Show prompt (usually on first question only).
  $('#prompt').children().remove();
  if (question.prompt !== undefined) {
    var promptAudio = soundManager.createSound({
      id : 'promptAudio',
      url : question.prompt.audio,
      multiShot : false
    });

    $('#prompt').append(
      '<p><img class=\"audioIcon\" src=\"../../../images/audio_icon.png\" />' + question.prompt.text + '</p>');

    $('#prompt').bind(CLICK, function() {
      soundManager.getSoundById('promptAudio').play();
    });
  }

  // Display question with optional audio link too.
  $('#question').children().remove();
  if (question.audio !== undefined) {
    var questionAudio = soundManager.getSoundById('questionAudio');
    if (questionAudio != null) {
      questionAudio.destruct();
    }
    questionAudio = soundManager.createSound({
      id : 'questionAudio',
      url : question.audio,
      multiShot : false
    });
    $('#question').append(
        '<p><img id=\"questionAudioIcon\" class=\"audioIcon\" src=\"../../../images/audio_icon.png\" />' + question.text
            + '</p>');
    $('#questionAudioIcon').bind(CLICK, function() {
      soundManager.getSoundById('questionAudio').play();
    });
  } else {
    $('#question').append('<p>' + question.text + '</p>');
  }

  // Add padding to make room for pointer.
  if (question.paddingTop !== undefined && question.paddingTop > 0) {
    $('#quizImage').css({
      'padding-top' : question.paddingTop + "px"
    });
  } else {
    $('#quizImage').css({
      'padding-top' : "0px"
    });
  }
  if (question.paddingRight !== undefined && question.paddingRight > 0) {
    $('#quizImage').css({
      'padding-right' : question.paddingRight + "px"
    });
  } else {
    $('#quizImage').css({
      'padding-right' : "0px"
    });
  }

  // Draw pointers once image is loaded.
  $('#quizImage > img').load(function() {
    $('#quizImage').fadeIn(FADE_IN_SPEED);
    for (i = 0; i < question.pointers.length; i++) {
      var pointer = question.pointers[i];
      $('#quizImage').append('<img id=\"pointer' + i + '\" src=\"../../../images/' + pointer.img + '\" />');
      if (pointer.rotation !== undefined && pointer.rotation != 0) {
        // Setup listener for IE to do proper rotations.
        if(jQuery.browser.msie) {
          Transformie.track('#pointer' + i);
        }

        $('#pointer' + i).css({
          'position' : 'absolute',
          'left' : pointer.x + "px",
          'top' : pointer.y + "px",
          'transform' : 'rotate(' + pointer.rotation + 'deg)',
          '-moz-transform' : 'rotate(' + pointer.rotation + 'deg)',
          '-webkit-transform' : 'rotate(' + pointer.rotation + 'deg)'
        });
      } else {
        // No need to rotate pointer image
        $('#pointer' + i).css({
          'position' : 'absolute',
          'left' : pointer.x + "px",
          'top' : pointer.y + "px"
        });
      }
    }
  });

  // Display answers and optional audio link too.
  $('#answers').children().remove();
  for (i = 0; i < question.options.length; i++) {
    var checked = "";
    if (answers[currentQuestionId] == question.options[i].text) {
      checked = "checked=\"checked\" ";
    }

    if (question.options[i].audio !== undefined) {
      var answerSound = soundManager.getSoundById('audio' + i);
      if (answerSound != null) {
        answerSound.destruct();
      }
      answerSound = soundManager.createSound({
        id : 'audio' + i,
        url : question.options[i].audio,
        multiShot : false
      });
      
      // Generate random hex colour for audio icon.
      var randomHexColor = ('00000'+(Math.random()*(1<<24)|0).toString(16)).slice(-6);
      
      $('#answers')
        .append(
          '<li style=\"margin-left: 50px;\"><img id=\"audioIcon'
              + i
              + '\" class=\"audioIcon\" style=\"width:32px; height: 32px; border: 1px solid black; background-color:#' + randomHexColor + '; padding: 0px; margin-left: -100px; margin-right: 75px;\" src=\"../../../images/audio_hidden.png\" /><input id=\"answer'
              + i + '\" type=\"radio\" ' + checked + 'name=\"question' + currentQuestionId + '\" value=\"'
              + question.options[i].text + '\"/><label for=\"answer' + i + '\" onclick=\"\">' + question.options[i].text
              + '</label></li>');      
      $('#audioIcon' + i).bind(MOUSEOVER, {
        'soundId' : i,
        'hexColor' : randomHexColor
      }, function(event) {
        soundManager.getSoundById('audio' + event.data.soundId).play({
          onfinish: function() {
            $('#audioIcon' + event.data.soundId).attr("src", "../../../images/audio_hidden.png");
            $('#audioIcon' + event.data.soundId).css({'background-color' : event.data.hexColor});        
          }
        });
        $(this).attr("src", "../../../images/audio_icon.png");
        $(this).css({'background-color' : 'none'});        
      });      
    } else {
      $('#answers').append(
        '<li><input id=\"answer' + i + '\" type=\"radio\" ' + checked + 'name=\"question' + currentQuestionId + '\" value=\"'
          + question.options[i].text + '\"/><label for=\"answer' + i + '\" onclick=\"\">' + question.options[i].text
          + '</label></li>');
    }

  }

  // Clear any existing messages.
  $('#messages').children().remove();
}

function showResults() {
  // Remove click handler and enable buttons.
  $(document).unbind(CLICK);
  $("#quizSubmit").removeAttr('disabled');
  $("#quizSkip").removeAttr('disabled');
  $("#quizBack").removeAttr('disabled');

  // Show results image background.
  $('#quiz').children().remove();
  $('#quiz').append('<img src=\"' + image + '\" />');

  // Calculate final score.
  var score = 0;
  for ( var i = 0; i < questions.length; i++) {
    var question = questions[i];
    for ( var j = 0; j < question.options.length; j++) {
      if (question.options[j].text == answers[i] && question.options[j].answer) {
        score++;
      }
    }
  }

  // Calculate results message (congratulations or try again).
  var message = (score == questions.length) ? msgCongratulations : msgTryAgain;

  // Show results
  $('#quiz').append(
    '<div id=\"quizResults\"><p>Your score: ' + score + '</p><p>Max score: ' + questions.length + '</p><p>' + message + '</div>');

  $('#quizResults').bind(CLICK, function() {
    // Restart game.
    showIntroduction();
  });
}

function previousQuestion() {
  if (currentQuestionId > 0) {
    currentQuestionId--;
  }
  showQuestion();
}

function skipQuestion() {
  // Store empty answer if first time through, otherwise keep existing answer.
  if (answers[currentQuestionId] === undefined) {  
    answers[currentQuestionId] = '';
  }

  // Move to next question.
  currentQuestionId++;
  if (currentQuestionId < questions.length) {
    showQuestion();
  } else {
    showResults();
  }
}

function submitQuestion() {
  // Get current question.
  var question = questions[currentQuestionId];

  var checked = false;
  $('li > input').each(function() {
    if ($(this).attr("checked")) {
      checked = true;
      // Store chosen answer.
      answers[currentQuestionId] = $(this).attr("value");

      // Display correct/incorrect message
      for (i = 0; i < question.options.length; i++) {
        if (question.options[i].text == answers[currentQuestionId]) {
          $('#messages').children().remove();
          if (question.options[i].answer) {
            $('#messages').append('<p style=\"color: #007A00;\">' + msgCorrect + '</p>');
          } else {
            $('#messages').append('<p style=\"color: #ff0000;\">' + msgIncorrect + '</p>');
          }
          
          // Click anywhere to continue.
          setTimeout(function() {
            // Disable buttons to prevent future clicks being counted.
            $("#quizSubmit").attr('disabled', 'disabled');
            $("#quizSkip").attr('disabled', 'disabled');
            $("#quizBack").attr('disabled', 'disabled');

            // Bind a click handler on document.
            $(document).bind(CLICK, function() {    
              // Move to next question.
              currentQuestionId++;
              if (currentQuestionId < questions.length) {
                showQuestion();
              } else {
                showResults();
              }
            });
          }, 500);
          
          break;
        }
      }

    }
  });

  if (!checked) {
    $('#messages').children().remove();
    $('#messages').append('<p style=\"color: #99994C;\">' + msgPleaseAnswer + '</p>');
  }

}