  var bubble_x_offset = 15;
  var bubble_y_offset = 150;

  var timeoutVariable;
  var lastAudioId;
  var sounds = new Array();
  
  var isTouch = ('ontouchstart' in window);
  var CLICK = isTouch ? 'touchstart' : 'click';

  function _findPos(obj) {
    var curleft = curtop = 0;
  	if (obj.offsetParent) {
  	  do {
        curleft += obj.offsetLeft;
        curtop += obj.offsetTop;
      } while (obj = obj.offsetParent);
    }
    return [curleft,curtop];
  }
  
  function _showBubble(id, area) {
    lastAudioId = id;
	
    var boxLeft = _findPos(document.getElementById('law_box'))[0];
    var boxTop = _findPos(document.getElementById('law_box'))[1];
    
    var coords = area.coords.split(',');
    
    $("#bubble").html(document.getElementById(id).title.replace(/ /g, "&nbsp;"));
    $("#bubble").css({"left":(boxLeft + (coords[0] - bubble_x_offset)) + "px"});
    $("#bubble").css({"top":(boxTop + (coords[1] - bubble_y_offset)) + "px"});
    $("#bubble").css({"display":"block"});
  }
  
  function _playAudio(id) {
	soundManager.getSoundById(id).play();
  }
  
  function onAreaMouseOver(id, area) {
    // No concept of mouse over on touch devices.
    if (!isTouch) {
	  _playAudio(id);
      _showBubble(id, area);
    }
  }
  
  function onAreaClick(id, area) {
	_playAudio(id);
    _showBubble(id, area);
  }

  $("#mask").bind(CLICK, function(e) {
    e.preventDefault();
    $("#bubble").addClass("speech");
    $("#bubble").removeClass("about");      
        
    $('#mask, #bubble').hide();
  });
  
  $("#bubble").bind(CLICK, function(e) {
    if ($(this).is(".speech")) {
      _playAudio(lastAudioId);
    } else if ($(this).is(".about")) {
      e.preventDefault();
      $("#bubble").addClass("speech");
      $("#bubble").removeClass("about");      
        
      $('#mask, #bubble').hide();
    }
  });
    
  $("#bubble.speech").mouseover(function() {
    clearTimeout(timeoutVariable);
  });

  $("#bubble.speech").mouseout(function() {
    timeoutVariable = setTimeout(function() {
      $("#bubble").css({"display":"none"});
      $("#bubble").html("");
	  }, 500);
  });

  $("area").mouseover(function() {
    clearTimeout(timeoutVariable);
  });

  $("area").mouseout(function() {
    timeoutVariable = setTimeout(function() {
      $("#bubble").css({"display":"none"});
      $("#bubble").html("");
	  }, 500);
  });
  
  $(document).ready(function() {
    // Hide text version of site
      var tvw = $("#textVersion").outerWidth();
    $("#textVersion").css({"position": "absolute", "left" : (-tvw) + "px", "top" : "60px"});
    $("#textVersion li").css({"display" : "list-item"});
    
    // Enable toggle controls.
    $("#tools").css({"display":"block"});
    
    // Attach "text version" event handler
    $("#textToggle").bind(CLICK, function(e) {
      e.preventDefault();      
      if ($("#textVersion").position().left == 0) {
        $("#textVersion").animate({left: "-=" + tvw + "px"}, 250 );
      } else if ($("#textVersion").position().left == -tvw) {
        $("#textVersion").animate({left: "+=" + tvw + "px"}, 250 );
      }
    });
    
    // Attach "about" event handler
    $("#about a").bind(CLICK, function(e) {
      e.preventDefault();      
//      if (isTouch) {
        // Remove mention of mouse on touch devices.
//        $("#bubble").html($(this).attr("title").replace("Roll your mouse over", "Touch"));      
//      } else {
//        $("#bubble").html($(this).attr("title"));
//      }
        // Remove mention of mouse on all devices.
        $("#bubble").html($(this).attr("title").replace("Roll your mouse over", "Touch"));      
      
      // Convert speech bubble to alert.
      $("#bubble").css({"display":"block"});
      $("#bubble").removeClass("speech");
      $("#bubble").addClass("about");

      // Fill screen background with mask.      
      var maskHeight = $(document).height();
      var maskWidth = $(window).width();
      $("#mask").css({'width':maskWidth,'height':maskHeight});
      $("#mask").fadeTo("fast",0.6);
    });    
  });

  soundManager.onready(function() {
    $("audio").each(function() {
      var tmp = soundManager.createSound({
        id : $(this).attr("id"),
        url : $(this).attr("src"),
        multiShot : false
      });
    });
  });