/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.MultiPageDocument;
import org.freehep.graphicsio.exportchooser.Options;
import org.freehep.graphicsio.exportchooser.ProgressDialog;
import org.freehep.util.export.ExportFileType;

public abstract class AbstractExportFileType
extends ExportFileType {
    public VectorGraphics getGraphics(File file, Component component) throws IOException {
        return this.getGraphics(new BufferedOutputStream(new FileOutputStream(file)), component);
    }

    public abstract VectorGraphics getGraphics(OutputStream var1, Component var2) throws IOException;

    public void exportToFile(OutputStream outputStream, Component component, Component component2, Properties properties, String string) throws IOException {
        VectorGraphics vectorGraphics = this.getGraphics(outputStream, component);
        if (vectorGraphics != null) {
            vectorGraphics.setCreator(string);
            vectorGraphics.setProperties(properties);
            vectorGraphics.startExport();
            component.print(vectorGraphics);
            vectorGraphics.endExport();
        }
    }

    public void exportToFile(File file, Component component, Component component2, Properties properties, String string) throws IOException {
        VectorGraphics vectorGraphics = this.getGraphics(file, component);
        if (vectorGraphics != null) {
            vectorGraphics.setCreator(string);
            vectorGraphics.setProperties(properties);
            vectorGraphics.startExport();
            component.print(vectorGraphics);
            vectorGraphics.endExport();
        }
    }

    public void exportToFile(OutputStream outputStream, Component[] componentArray, Component component, Properties properties, String string) throws IOException {
        ProgressDialog progressDialog = null;
        MultiPageSingleFileExportThread multiPageSingleFileExportThread = null;
        VectorGraphics vectorGraphics = this.getGraphics(outputStream, componentArray[0]);
        if (vectorGraphics != null && vectorGraphics instanceof MultiPageDocument) {
            vectorGraphics.setCreator(string);
            vectorGraphics.setProperties(properties);
            progressDialog = new ProgressDialog(component, componentArray.length * 3 + 2, "Writing header...");
            MultiPageDocument multiPageDocument = (MultiPageDocument)((Object)vectorGraphics);
            multiPageDocument.setMultiPage(true);
            multiPageSingleFileExportThread = new MultiPageSingleFileExportThread(multiPageDocument, vectorGraphics, componentArray, progressDialog, outputStream);
            multiPageSingleFileExportThread.start();
            progressDialog.setVisible(true);
            IOException iOException = progressDialog.getException();
            if (iOException != null) {
                throw iOException;
            }
        } else {
            System.out.println("Cannot write multi files to one output stream.");
        }
    }

    public void exportToFile(File file, Component[] componentArray, Component component, Properties properties, String string) throws IOException {
        Object object;
        ProgressDialog progressDialog = null;
        CancelThread cancelThread = null;
        VectorGraphics vectorGraphics = this.getGraphics(file, componentArray[0]);
        if (vectorGraphics != null && vectorGraphics instanceof MultiPageDocument) {
            vectorGraphics.setCreator(string);
            vectorGraphics.setProperties(properties);
            progressDialog = new ProgressDialog(component, componentArray.length * 3 + 2, "Writing header...");
            object = (MultiPageDocument)((Object)vectorGraphics);
            object.setMultiPage(true);
            cancelThread = new MultiPageSingleFileExportThread((MultiPageDocument)object, vectorGraphics, componentArray, progressDialog, file);
        } else {
            progressDialog = new ProgressDialog(component, componentArray.length + 2, "Exporting files...");
            cancelThread = new MultipageMultipleFilesExportThread(componentArray, file, progressDialog, component, properties, string);
        }
        cancelThread.start();
        progressDialog.setVisible(true);
        object = progressDialog.getException();
        if (object != null) {
            throw object;
        }
    }

    public boolean applyChangedOptions(JPanel jPanel, Properties properties) {
        if (jPanel instanceof Options) {
            return ((Options)((Object)jPanel)).applyChangedOptions(properties);
        }
        System.err.println(this.getClass() + ": applyChangedOptions(...), panel does not implement Options interface.");
        return false;
    }

    public abstract class CancelThread
    extends Thread {
        private boolean stop;
        private File currentFile;
        private OutputStream currentOut;
        ProgressDialog progress;

        private CancelThread(ProgressDialog progressDialog) {
            this.progress = progressDialog;
            this.stop = false;
            progressDialog.interruptOnCancel(this);
        }

        abstract void export() throws IOException;

        public void cancel() {
            this.stop = true;
        }

        public boolean isStopped() {
            return this.stop;
        }

        public void run() {
            block4: {
                try {
                    this.export();
                }
                catch (IOException iOException) {
                    if (this.stop) break block4;
                    this.progress.exceptionOccured(iOException);
                }
            }
            try {
                this.cleanUp();
            }
            catch (IOException iOException) {
                System.err.println("While cleaning up:");
                iOException.printStackTrace();
            }
        }

        void setCurrentFile(File file) {
            this.currentFile = file;
        }

        void setCurrentOutputStream(OutputStream outputStream) {
            this.currentOut = outputStream;
        }

        void cleanUp() throws IOException {
            if (this.currentOut != null) {
                this.currentOut.close();
            }
            if (this.currentFile != null) {
                this.currentFile.delete();
            }
        }
    }

    private class MultiPageSingleFileExportThread
    extends CancelThread {
        private MultiPageDocument mdoc;
        private VectorGraphics graphics;
        private Component[] saveTargets;

        private MultiPageSingleFileExportThread(MultiPageDocument multiPageDocument, VectorGraphics vectorGraphics, Component[] componentArray, ProgressDialog progressDialog) {
            super(progressDialog);
            this.mdoc = multiPageDocument;
            this.graphics = vectorGraphics;
            this.saveTargets = componentArray;
            this.progress = progressDialog;
        }

        private MultiPageSingleFileExportThread(MultiPageDocument multiPageDocument, VectorGraphics vectorGraphics, Component[] componentArray, ProgressDialog progressDialog, OutputStream outputStream) {
            this(multiPageDocument, vectorGraphics, componentArray, progressDialog);
            this.setCurrentOutputStream(outputStream);
        }

        private MultiPageSingleFileExportThread(MultiPageDocument multiPageDocument, VectorGraphics vectorGraphics, Component[] componentArray, ProgressDialog progressDialog, File file) {
            this(multiPageDocument, vectorGraphics, componentArray, progressDialog);
            this.setCurrentFile(file);
        }

        void export() throws IOException {
            this.graphics.startExport();
            for (int i2 = 0; i2 < this.saveTargets.length; ++i2) {
                if (this.isStopped()) {
                    return;
                }
                if (this.graphics == null || this.mdoc == null) continue;
                this.progress.step("Writing page " + (i2 + 1) + "/" + this.saveTargets.length + ".");
                this.mdoc.openPage(this.saveTargets[i2]);
                if (this.isStopped()) {
                    return;
                }
                this.progress.step("Writing page " + (i2 + 1) + "/" + this.saveTargets.length + "..");
                this.saveTargets[i2].print(this.graphics);
                if (this.isStopped()) {
                    return;
                }
                this.progress.step("Writing page " + (i2 + 1) + "/" + this.saveTargets.length + "...");
                this.mdoc.closePage();
                if (!this.isStopped()) continue;
                return;
            }
            if (this.isStopped()) {
                return;
            }
            this.progress.step("Writing trailer...");
            this.graphics.endExport();
            this.setCurrentOutputStream(null);
            this.setCurrentFile(null);
            this.progress.dispose();
        }
    }

    private class MultipageMultipleFilesExportThread
    extends CancelThread {
        private File file;
        private Component[] saveTargets;
        private Component parent;
        private Properties properties;
        private String creator;

        private MultipageMultipleFilesExportThread(Component[] componentArray, File file, ProgressDialog progressDialog, Component component, Properties properties, String string) {
            super(progressDialog);
            this.file = file;
            this.saveTargets = componentArray;
            this.parent = component;
            this.properties = properties;
            this.creator = string;
        }

        void export() throws IOException {
            for (int i2 = 0; i2 < this.saveTargets.length; ++i2) {
                if (this.isStopped()) {
                    this.cleanUp();
                    return;
                }
                this.progress.step("Page " + (i2 + 1) + "/" + this.saveTargets.length + "...");
                String string = this.file.getAbsolutePath();
                int n2 = string.lastIndexOf(".");
                if (n2 == -1) {
                    n2 = string.length() - 1;
                }
                string = string.substring(0, n2) + "-" + (i2 + 1) + string.substring(n2);
                File file = new File(string);
                this.setCurrentFile(file);
                AbstractExportFileType.this.exportToFile(file, this.saveTargets[i2], this.parent, this.properties, this.creator);
                this.setCurrentFile(null);
            }
            this.progress.dispose();
        }
    }
}

