//version 1.2
//last modified October 10 2007
function addLoadEvent(func) {
  var oldonload = window.onload;
  if (typeof window.onload != 'function') {
    window.onload = func;
  } else {
    window.onload = function() {
      if (oldonload) {
        oldonload();
      }
      func();
    }
  }
}

function navigate(id,currentElement){
     if(document.getElementById(id)){
         closeSiblingsAndTheirDescendants(id,currentElement,false);
         toggle(id,currentElement, true);
         makeCurrent(currentElement);
     }
}

function closeSiblingsAndTheirDescendants(id,currentElement,keepLastState){
/*
    Closes other navigation items of the same level and their subitems
    Arguments:
    id - the id of the item associated with the element that has been clicked
    currentElement - the element which has been clicked
    keepLastState - indicates whether or not the subitems should be closed before opening another item
                    this means that when the item is reopened the page remembers where you were
*/
	var NODETYPE_ELEMENT = 1;
	var NODETYPE_TEXT = 3;
	var display = document.getElementById(id).style.display;
    var state = (display=="" || display=="none")?"none":"block";
	var FirstLevel = id.indexOf('_') == -1;//is the item a first level item?
    var hasChildren = "no"; //does the item have subItems?
    for(x=0;x<document.getElementById(id).childNodes.length;x++){
        if(document.getElementById(id).childNodes[x].nodeName == "UL"){
            hasChildren = "yes";
        }
    }
    var firstLevelCount = 0; //how many first level items are there?
    for(x=0;x<document.getElementById("menu").childNodes.length;x++){
        if(document.getElementById("menu").childNodes[x].nodeType == NODETYPE_ELEMENT){
            firstLevelCount +=1;
        }
    }
	
	
	if(FirstLevel){
	    
	    //collapse any open first level items
	    for(x=1;x<firstLevelCount + 1;x++){
	        //close the nested list if it is displayed
	        //first, loop through childnodes looking for the UL
            var currentMenu = "menu" + x;
            var menuNode = document.getElementById(currentMenu);
            for(y=0;y<menuNode.childNodes.length;y++){
                //if you find a UL hide it
                if(menuNode.childNodes[y].nodeName == "UL"){
                    var secondLevelUL = menuNode.childNodes[y];
                    
                    if(keepLastState == false){
                        //hide any third level items showing
                        for(z=0;z<secondLevelUL.childNodes.length;z++){
                            if(secondLevelUL.childNodes[z].nodeName == "LI"){
                               for(liChildren=0;liChildren<secondLevelUL.childNodes[z].childNodes.length;liChildren++){
                                   if(secondLevelUL.childNodes[z].childNodes[liChildren].nodeName == "UL" && currentMenu != id){
                                        removeClass(secondLevelUL.childNodes[z],"expanded");
                                        addClass(secondLevelUL.childNodes[z],"closed");
                                        secondLevelUL.childNodes[z].childNodes[liChildren].style.display = "none";
                                        secondLevelUL.childNodes[z].childNodes[liChildren].style.visibility = "hidden";
                                        //change alt text from expanded to closed
										var imgId = secondLevelUL.childNodes[z].id + "img";
                                        if(document.getElementById(imgId) && document.getElementById(imgId).getAttribute("alt")=="expanded"){
											document.getElementById(imgId).setAttribute("alt","closed");
                                        }
                                    }
                               }
                            }
                        }
                    }
                    //if it is not the current menu
                    if(currentMenu != id){
                        //hide the second level UL
                        menuNode.childNodes[y].style.display = "none";
                        menuNode.childNodes[y].style.visibility = "hidden";
                        //change the parent LI class name from expanded to closed
                        removeClass(menuNode,"expanded");
                        addClass(menuNode,"closed");
						var LevelOneImgId = currentMenu + "img";
						if(document.getElementById(LevelOneImgId) && document.getElementById(LevelOneImgId).getAttribute("alt")=="expanded"){
							document.getElementById(LevelOneImgId).setAttribute("alt","closed");
						}
                    }
                    
                }
            }
	    }
	}else{ 
	    // second level
	    //get the third level number, the id passed in will be like menu2_2
	    var posOfUnderscore=id.indexOf('_');
	    var secondLevelNum = id.substr(4, posOfUnderscore-4);
	    //if menux_0 exists start from there if not from 1
	    var startPoint = document.getElementById('menu' + secondLevelNum + '_'+0)?0:1;
	    // find out how many second level items there are in this section
	    var secondLevelCount = 0;
        for(x=0;x<document.getElementById(id).parentNode.childNodes.length;x++){
            if(document.getElementById(id).parentNode.childNodes[x].nodeType == NODETYPE_ELEMENT){
                secondLevelCount +=1;
            }
        }
	    var nodeNumber = "";
        for(y=0;y<document.getElementById('menu' + secondLevelNum).childNodes.length;y++){
            if(document.getElementById('menu' + secondLevelNum).childNodes[y].nodeName == "UL"){
                nodeNumber = y;
            }
        }
	    //loop through the second level menu items and hide all third menu items not under the current node
	    for (var i = startPoint; i <= secondLevelCount; i++) {
		    if(id != 'menu' + secondLevelNum + "_" + i){
		        currentSecondLevelID = "menu"+ secondLevelNum + "_" + i;
		        currentSecondLevel = document.getElementById(currentSecondLevelID);
		        //change class name for items we are closing
		        if(currentSecondLevel.className.indexOf("expanded") != -1){
		            removeClass(currentSecondLevel,"expanded");
                    addClass(currentSecondLevel,"closed");
		        } 
				var currentSecondLevelImgId = currentSecondLevelID + "img";
				if(document.getElementById(currentSecondLevelImgId) && document.getElementById(currentSecondLevelImgId).getAttribute("alt")=="expanded"){
					document.getElementById(currentSecondLevelImgId).setAttribute("alt","closed");
				}
		        //hide the third level items
		        for(z=0;z<currentSecondLevel.childNodes.length;z++){
                    if(currentSecondLevel.childNodes[z].nodeName == "UL"){
	                    currentSecondLevel.childNodes[z].style.display='none';
	                    currentSecondLevel.childNodes[z].style.visibility='hidden';
                    }
                }
		    }
	    } 
	}
	// at this point all list items are hidden except the current one
}

function toggle(id,currentElement, currentTopCloses){
    /*
    Opens the item if it is closed 
    If currentTopCloses = true, it also closes the item if it is open
    Arguments:
    id - the id of the item associated with the element that has been clicked
    currentElement - the element which has been clicked
    currentTopCloses - indicates whether or not the item will close if clicked when it is open
    */
    var item = document.getElementById(id);
    //link
    var linkPos=0;
    //loop through childnodes looking for the UL
    for(x=0;x<item.childNodes.length;x++){
        if(item.childNodes[x].nodeName =="A"){
            linkPos = x;
        }
        if(item.childNodes[x].nodeName == "UL"){
            if(currentTopCloses == true){
                //toggle
                if(item.childNodes[linkPos].nodeName == "A" && item.childNodes[linkPos].parentNode.className =='expanded'){
                   //close the open top level item
                   item.childNodes[x].style.display="none";
                   item.childNodes[x].style.visibility="hidden";
                   removeClass(item,'expanded');
                   addClass(item,'closed');
                   item.childNodes[linkPos].childNodes[linkPos].setAttribute("alt","closed");
                }else{
                    item.childNodes[x].style.display = 'block';
                    item.childNodes[x].style.visibility = 'visible';
                    removeClass(item,'closed');
                    addClass(item,'expanded');
                    item.childNodes[linkPos].childNodes[linkPos].setAttribute("alt","expanded");
                }
            }else{
            //show 
            item.childNodes[x].style.display = 'block';
            item.childNodes[x].style.visibility = 'visible';
            removeClass(item,'closed');
            addClass(item,'expanded');
            }
        }
        //if you find an image change the src from plus to minus
        if(document.getElementById(id + "img") && document.getElementById(id + "img").src.indexOf("menu_t.gif")!=-1){
            document.getElementById(id + "img").setAttribute("alt","expanded");
        }
        
    }
    
}

function makeCurrent(theElement){
	linklength = document.links.length;
	for(i=0;i<linklength;i++){
		if(document.links[i].className.indexOf("current")>-1) {
			removeClass(document.links[i],'current');
		}
	}
	addClass(theElement,'current');
}

function addClass(target, classValue){
    var pattern = new RegExp("(^| )" + classValue + "( |$)");
    if(!pattern.test(target.className)){
        if(target.className == ""){
            target.className = classValue;
        }else{
            target.className += " " + classValue;
        }
    }
}

function removeClass(target, classValue){
    var removedClass = target.className;
    var pattern = new RegExp("(^| )" + classValue + "( |$)");
    removedClass = removedClass.replace(pattern, "$1");
    removedClass = removedClass.replace(/ $/, "");
    target.className = removedClass;
    return true;
}


function parseObj(obj) {
	var x=0;
	var result='';
	for (var prop in obj) {
		result+=prop + ': ' + obj[prop] + '\n';
		if (++x > 10) {
			alert (result);
			x=0;
			result='';
		}
	}
	alert (result);
}