/* Display a PrintFriendly version of the current page
	Reads the Document and does the following:
	-	Removes all head elements except the Print stylesheet and the title
	-  Renders all content from layers without the original layer
	-  Displays the refined version in a new window 
*/
function PrintFriendlyPage() {
	// if IE5.0 or 5.5 on Windows strip divs and print from there, otherwise just print
	if((navigator.userAgent.indexOf("MSIE 5") != -1) && (navigator.platform.indexOf("Win") != -1)){
		start="\<html\>\<head\>";					// HTML until the title
		title=getTitle();							// Gets the title, with HTML tags
		printStyleSheet=_getPrintStyleSheet();		// Retrieves the print stylesheet (a link element with media attribute='print'
		afterTitle="\<\/head\>\<body onload='alert(\"Print this window by pressing Control + P (Windows) or Apple + P (Mac). Then close the window to return\");'\>";			// close head, open body tag
		end="\<\/body\>\<html\>";					//	close the body and html tags
		removeDivs=_removeDivs();					// take all content out of layers
		// put all the HTML together
		makePrintFriendlyPage=start + title + printStyleSheet + afterTitle + removeDivs + end;
		// show the new HTML in a new window
		displayPrintFriendlyPage();
		
	}else{
			if((navigator.platform.indexOf("Mac") != -1) && (navigator.userAgent.indexOf("Netscape") == -1)){
				if(navigator.userAgent.indexOf("Safari") != -1){
					alert("Safari does not support this function. Please choose print from the file menu. For best results ensure the default font size is set to 14 in File/preferences/appearance.");
				}else{
					alert("Your browser does not support this function. Please choose print from the file menu.");
				}
			}else{
				window.print();
			}
	}
}

		/* 
			Gets the title element
		*/
		function getTitle() {
			var  title=document.getElementsByTagName('title');
			return "\<title\>" +  title[0].innerHTML + "\<\/title\>";
		}
		
		/* 
			Gets all the div tags, and re-renders the content without the div tag
		*/
		function _removeDivs() {

			var divs=document.body.getElementsByTagName("div");
			var newDoc='';
			for  (x=0;x<divs.length;x++) {
				var a=divs[x].innerHTML;
				//remove lyrTop content but include the rest
				if(divs[x].id == "lyrTop" || divs[x].id == "header"){
				}else{
				if (a.indexOf('navBot')>-1) {
					a=StripNavBotClass(a);
				}
				 newDoc+=a;
				}
			}
			return newDoc;
		}
function StripNavBotClass(divIn) {
	try {
		//make a lower case copy of the div in case some p tags are in uppercase
		var divLower=divIn.toLowerCase();
		
		//get the string before the p tag with a class of navBot
		var posNavBot=divIn.indexOf('navBot');
		var divBeforeNavBot=divLower.substr(0, posNavBot);
		var posStartTag=divBeforeNavBot.lastIndexOf("<p");
		
		var firstPartForFinal=divIn.substr(0,posStartTag);
		
		
		//get the string after the p tag with a class of navBot
		var posEndTag=divLower.indexOf("</p>", posStartTag) + 4;
		var lastPartForFinal=divIn.substr(posEndTag);
		
		//output the div without the paragraph with class of navBot
		var result= firstPartForFinal + lastPartForFinal;
		// check if there are more navBot paras, and maybe recurse
		if (result.indexOf('navBot')>-1) {
			return (StripNavBotClass(result));
		}
		return result;
	} catch (e){
	// really bad HTML coding ciould result in errors.
	// if there is a situation, we don't want to recurse infinitely, so remove all navBots
		return divIn.replace("navBot", "");
	}
}
		/* 
			Opens a new window and displays the PrintFriendly HTML
		*/
		function displayPrintFriendlyPage() {
			var win=window.open('','test');
			win.document.write (this.makePrintFriendlyPage);
			win.document.close();
		}

		
		/* 
			Gets all the print stylesheet, defined as a link element with a 'media' attribute
			equal to 'print'
		*/
		function _getPrintStyleSheet() {
			var  links=document.getElementsByTagName("link")
			for (var x=0;x<links.length;x++) {
				if (links[x].media =="print") {
					return "\<link rel=\"stylesheet\" href=\"" + links[x].href + "\" media=\"print\"\/\>";;
				}
			}
		}
function parseObj(obj) {
	var x=0;
	var result='';
	for (var prop in obj) {
		result+=prop + ': ' + obj[prop] + '\n';
		if (++x > 10) {
			alert (result);
			x=0;
			result='';
		}
	}
	alert (result);
}
