//mw - 2014_9_video.js wrapper
	function loadScript(url, callback){
		var script = document.createElement("script")
		script.type = "text/javascript";

		if (script.readyState){  //IE
			script.onreadystatechange = function(){
				if (script.readyState == "loaded" ||
						script.readyState == "complete"){
					script.onreadystatechange = null;
					callback();
				}
			};
		} else {  //Others
			script.onload = function(){
				callback();
			};
		}
		script.src = url;
		document.getElementsByTagName("head")[0].appendChild(script);
    }
	
	function loadVideojs(videoelement){
	
		if( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
			//load video.min.4.8.js - captions work on iOS but not IE9. 2014-9-22
			var head = document.getElementsByTagName('head')[0];
			var js = document.createElement("script");
			
			js.type = "text/javascript";
			js.src = "scripts/video.min.4.8.js";
			head.appendChild(js);
			
			//These lines don't work
			//videojs.options.flash.swf = "players/video-js.swf";
			//videojs(videoelement,{ "autoplay": false });
						
		}
		else {
			//load video.4.3.js - captions work on IE9+ and other broswers, but not iOS
			loadScript("scripts/video.min.4.3.js", function(){
		    videojs.options.flash.swf = "../players/video-js.swf";
			videojs(videoelement,{ "autoplay": false });
		  });
		}
	}
	
	function disposeVideoJs(videoElement){
		videojs(videoElement).dispose();
	}
	
	
	function toggleVideos(videoplayerId, srId, toggleLinkId, audioDescText, normalVideoText, normalVideo, audioDescVideo, vttCaption, poster){
			
           		$(toggleLinkId).on('click',function () {
										
					disposeVideoJs(videoplayerId);
					
					var video = '<video tabindex="0" Id="'+ videoplayerId +'" controls class="video-js vjs-default-skin" poster="'+ poster +'" preload="auto" data-setup=\'{"nativeControlsForTouch": false}\'>';
															
					if($(srId).text() == audioDescText){							
						$(srId).text(normalVideoText);
						$(toggleLinkId).removeClass('audioDescription');
						$(toggleLinkId).addClass('standardVideo');
						video += '<source type="video/mp4" src="' + audioDescVideo + '">';
					}
					else {
						$(srId).text(audioDescText);
						$(toggleLinkId).removeClass('standardVideo');
						$(toggleLinkId).addClass('audioDescription');
						video += '<source type="video/mp4" src="' + normalVideo + '">';
					}
					
					video += '<track kind="captions" src="'+ vttCaption +'" srclang="en" label="On">';
					video += '</video>';
					
					$('#videoContainer').prepend(video);
					
					loadVideojs(videoplayerId);							
			});	
					
	}
	
	
	
	
	var sheet = (function() {
	// Create the <style> tag
	var style = document.createElement("style");
	
	// WebKit hack :(
	style.appendChild(document.createTextNode(""));

	// Add the <style> element to the page
	document.head.appendChild(style);

	return style.sheet;
	})();
	if( /iPhone/i.test(navigator.userAgent) ) {
		sheet.insertRule("@media only screen and (min-device-width : 320px) and (max-device-width : 568px) {.vjs-default-skin .vjs-big-play-button{	display:none;}	}", 0);
	}	