/* Author:

*/


$(document).ready(function () {

    // Run Matt Kersley's jQuery Responsive menu plugin (see plugins.js)
    if ($.fn.mobileMenu) {
        $('ol#id').mobileMenu({
            switchWidth: 768,                   // width (in px to switch at)
            topOptionText: 'Choose a page',     // first option text
            indentString: '&nbsp;&nbsp;&nbsp;'  // string for indenting nested items
        });
    }

    // Run Mathias Bynens jQuery placeholder plugin (see plugins.js)
    if ($.fn.placeholder) {
        $('input, textarea').placeholder();
    }

});


function initPrintAndOrCloseLinks() {
    if (typeof document.getElementById != 'undefined') {
        if (document.getElementById('popup') || document.getElementById('show')) {
            addPrintAndCloseLinks();
        } else if (document.getElementById('feedback')) {
            addPrintLink();
        }
    }
}



//this function convert clips tables to responsive tables 
function renderTables() {
   // renderLayoutTables();
    renderTabularTables();

}


function renderTabularTables() {
    var tabularTables = $('table[class="tabular"]');

    $.each(tabularTables, function () {

        //if (($(this).attr('class') == 'tabular') ) {

        var thead = $(this).children('thead');
        var trArray = $(this).find('tr');
        var thArray = $(this).find('th');


        var currentTable = $(this);

        // counts total number of td in a head so that we can can use it for label extraction

        var head_col_count = $('tr th', currentTable).size();

        // loop which replaces td

        for (i = 0; i <= head_col_count; i++) {

            // head column label extraction

            var head_col_label = $('thead  tr th:nth-child(' + i + ')', currentTable).text();

            // replaces td with <div class="column" data-label="label">

            $('tr td:nth-child(' + i + ')', currentTable).replaceWith(

    function () {

        return $('<div class="column" data-label="' + head_col_label + '">').append($(this).contents());

    }

);

        } //for





        // replaces table with <div class="table">


        currentTable = currentTable.replaceWith(function () {

            return $('<div class="table">').append($(this).contents());

        }

);

        // replaces thead with <div class="table-head">



        thead.replaceWith(

    function () {

        return $('<div class="table-head">').append($(this).contents());

    }

);

        // replaces tr with <div class="row">

        $.each(trArray, function () {
            $(this).replaceWith(
            function () {
                return $('<div class="row">').append($(this).contents());
            });
        });

        // replaces th with <div class="column">

        $.each(thArray, function () {

            $(this).replaceWith(
              function () {
                  return $('<div class="column">').append($(this).contents());

              });
        });

        //   } //if


    });             //each
}
function updateIFrames() {

    $('iframe').each(function(){
        $(this).removeAttr("allowfullscreen");
        $(this).removeAttr("frameborder");
    });
}
